﻿-- ■==============================================================================================■*/
--[[ !
    @file		ghost_highway_route_SANYO.lua
    @brief		全国街道チャレンジ ルート情報(山陽道)
    @author		AutoGenerated (otsuka-y)
    @date		2019/11/12 14:07:51
--]]
-- ■==============================================================================================■*/
-- ルートファイルのID
ROUTE_ID = "SANYO"
-- ルート名
ROUTE_NAME = "山陽道"

-- 門番・ボス分身を撃破することで入手可能な報酬
---- 記法
--   アイテムID, 報酬ID,
---- 報酬ID
--   どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける(201-299)
RewardTable = {
	[CAT_STAMP] = {
		146,205,
		147,206,
		134,207,
	},
	[CAT_HONOR] = {
		630013,205,
		630014,206,
		630001,207,
	},

}

-- マス情報
---- 記法
-- マス種別, 関所とショートカット先ID, 報酬ID
----マス種別
--   SHOP,          //! 店舗マス
--   START,         //! スタートマス
--   MANUFARACTUER, //! メーカーマス
--   RECENT,        //! 最近プレイした相手マス
--   UNKNOWN,       //! ハテナマス
--   BONUS,         //! ボーナスマス
--   STATION,       //! 関所分身マス
--   BOSS,          //! ボス分身マス
--   BLANK,         //! 空白マス
---- 関所とショートカット先ID
-- 関所とショートカット先に対して同じIDを使用する (101-199)
---- 報酬ID
-- どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける (201-299)
SquareTable = {
	START,
	SHOP,
	RECENT,
	MANUFARACTUER,
	BONUS,
	UNKNOWN,
	RECENT,
	SHOP,
	BONUS,
	RECENT,
	MANUFARACTUER,
	RECENT,
	BONUS,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	SHOP,
	UNKNOWN,
	RECENT,
	STATION,	103,	205,
	SHOP,
	UNKNOWN,
	MANUFARACTUER,
	RECENT,	103,
	UNKNOWN,
	RECENT,
	BONUS,
	SHOP,
	RECENT,
	SHOP,
	BONUS,
	SHOP,
	RECENT,
	SHOP,
	BONUS,
	UNKNOWN,
	RECENT,
	BONUS,
	RECENT,
	MANUFARACTUER,
	STATION,	104,	206,
	UNKNOWN,
	MANUFARACTUER,
	SHOP,
	BOSS,	104,	207,

}

-- 関所・ボス分身の情報テーブル
---- 記法
-- 車ID, 走行エリアID
---- 走行エリアID
--  Ａ１０１―３．分身・乱入・イベントモードのコースデータ→area IDに
-- 指定されている数値を指定 (0-17)
BarrierEmenyTable = {
	2014,
	2015,
	2002,9,

}

-- 双六マスインデント情報のテーブル(手動指定専用)
-- -- 記法
-- (通常ライン)          最初マスのインデント, 終了マスのインデント,
-- (ショートカットライン)最初マスのインデント, 終了マスのインデント,
-- 通常ライン
-- ショートカットライン
-- 通常ライン… これらをライン数分指定する
-- いずれのラインのインデントも設定しない場合はテーブル内は空欄でも可だが、
-- 1ラインでも指定する場合は、インデントしないラインは全て0で埋めること
LineIndentTable = {
	40,55,
	40,55,
	110,75,
	145,85,
	300,300,
	0,0,

}

-- 関所名リストテーブル
-- -- 記法
-- 関所名,
-- flashの関所名表示にのみ使用する
StationNameTable = {
	"Boji Pass",
	"Suma",

}

function GetRewardTable ( category_id )
    return unpack( RewardTable[category_id] )
end

function GetSquareTable( )
    return unpack( SquareTable )
end

function GetBarrierEnemyTable( )
    return unpack( BarrierEmenyTable )
end

function GetRouteName()
    return ROUTE_NAME
end

function GetLineIndentTable()
    return unpack( LineIndentTable )
end

function LineIndentTableSize()
    return #LineIndentTable
end

function GetStationNameTable()
    return unpack( StationNameTable )
end

function GetStationNameTableSize()
    return #StationNameTable
end
